#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

vector<vector<long>> Dinamicko(int n, const vector<long>& arr) {
    vector<vector<long>> dp(n, vector<long>(n, 0));

    for (int i = 0; i < n; i++) {
        dp[i][i] = arr[i];
    }

    for (int i = 0; i < n; i++) {
        for (int j = i+1; j < n; j++) {
            dp[i][j] = dp[i][j - 1] + arr[j];
        }
    }

    return dp;
}

unordered_map<long, vector<long>> pravljenje_recnika(vector<long>& arr) { //const?
    unordered_map<long, vector<long>> recnik;
    unordered_map<long, long> br;

    int n = arr.size();

    for (long val : arr) {
        recnik[val] = vector<long>(n, 0);
    }

    for (int i = 0; i < n; ++i) {
        long val = arr[i];
        br[val]++;

        for (pair<const long, vector<long>>& pair : recnik) {
            vector<long>& vec = pair.second;
            vec[i] = (i > 0 ? vec[i - 1] : 0);
        }

        recnik[val][i] = br[val];
    }

    return recnik;
}

int main() {
    //unos arr
    int n;
    cin >> n;
    
    vector<long> arr(n);
    for (int i = 0; i < n; ++i) {
        cin >> arr[i];
    }
    
    vector<vector<long>> podnizovi = Dinamicko(n, arr);
    unordered_map<long, vector<long>> recnik = pravljenje_recnika(arr);
    
    int resenje = 0;
    for(int i = 0; i<n;i++){
        for(int j=i;j<n;j++){
            if(podnizovi[i][j] == 0){  //edge case ako je i==j ???
                int mx = 0;
                for (const pair<long, vector<long>>& niz : recnik) {
                    const vector<long>& a = niz.second;
                    int pom;
                    if (i > 0) {
                        pom = a[j] - a[i-1];
                    } else {
                        pom = a[j];
                    }

                    mx = max(mx, pom);
                }

                resenje = max(resenje, mx);
            }
        }
    }
    
    cout<<resenje;
   
    return 0;
}